<script type="text/x-template" id="content-header-template">
    <header class="row velocity-divide-page vc-header header-shadow active">
        <div class="vc-small-screen container" v-if="isMobile()">
            <div class="row">
                <div class="col-6">
                    <div v-if="hamburger" class="nav-container scrollable">
                        <div class="wrapper" v-if="this.rootCategories">
                            <div class="greeting drawer-section fw6">
                                <i class="material-icons">perm_identity</i>
                                <span>
                                    <?php if(auth()->guard('customer')->guest()): ?>
                                        <a class="unset" href="<?php echo e(route('customer.session.index')); ?>">
                                        <?php echo e(__('velocity::app.responsive.header.greeting', ['customer' => 'Guest'])); ?>

                                        </a>
                                    <?php endif; ?>

                                    <?php if(auth()->guard('customer')->check()): ?>
                                        <a class="unset" href="<?php echo e(route('customer.profile.index')); ?>">
                                            <?php echo e(__('velocity::app.responsive.header.greeting', ['customer' => auth()->guard('customer')->user()->first_name])); ?>

                                        </a>
                                    <?php endif; ?>
                                    
                                    <i
                                        @click="closeDrawer()"
                                        class="material-icons pull-right text-dark">
                                        cancel
                                    </i>
                                </span>
                            </div>

                            <?php
                                $currency = $locale = null;

                                $currentLocale = app()->getLocale();
                                $currentCurrency = core()->getCurrentCurrencyCode();

                                $allLocales = core()->getCurrentChannel()->locales;
                                $allCurrency = core()->getCurrentChannel()->currencies;
                            ?>

                            <?php $__currentLoopData = $allLocales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appLocale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($appLocale->code == $currentLocale): ?>
                                    <?php
                                        $locale = $appLocale;
                                    ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php $__currentLoopData = $allCurrency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appCurrency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($appCurrency->code == $currentCurrency): ?>
                                    <?php
                                        $currency = $appCurrency;
                                    ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <ul type="none" class="velocity-content" v-if="headerContent.length > 0">
                                <li :key="index" v-for="(content, index) in headerContent">
                                    <a
                                        class="unset"
                                        v-text="content.title"
                                        :href="`${$root.baseUrl}/${content.page_link}`">
                                    </a>
                                </li>
                            </ul>

                            <ul type="none" class="category-wrapper" v-if="$root.sharedRootCategories.length > 0">
                                <li v-for="(category, index) in $root.sharedRootCategories">
                                    <a class="unset" :href="`${$root.baseUrl}/${category.slug}`">
                                        <div class="category-logo">
                                            <img
                                                class="category-icon"
                                                v-if="category.category_icon_path"
                                                :src="`${$root.baseUrl}/storage/${category.category_icon_path}`" />
                                        </div>
                                        <span v-text="category.name"></span>
                                    </a>

                                    <i class="rango-arrow-right" @click="toggleSubcategories(index, $event)"></i>
                                </li>
                            </ul>

                            <?php if(auth()->guard('customer')->check()): ?>
                                <ul type="none" class="vc-customer-options">
                                    <li>
                                        <a href="<?php echo e(route('customer.profile.index')); ?>" class="unset">
                                            <i class="icon profile text-down-3"></i>
                                            <span><?php echo e(__('shop::app.header.profile')); ?></span>
                                        </a>
                                    </li>

                                    <li>
                                        <a href="<?php echo e(route('customer.address.index')); ?>" class="unset">
                                            <i class="icon address text-down-3"></i>
                                            <span><?php echo e(__('velocity::app.shop.general.addresses')); ?></span>
                                        </a>
                                    </li>

                                    <li>
                                        <a href="<?php echo e(route('customer.reviews.index')); ?>" class="unset">
                                            <i class="icon reviews text-down-3"></i>
                                            <span><?php echo e(__('velocity::app.shop.general.reviews')); ?></span>
                                        </a>
                                    </li>

                                    <li>
                                        <a href="<?php echo e(route('customer.wishlist.index')); ?>" class="unset">
                                            <i class="icon wishlist text-down-3"></i>
                                            <span><?php echo e(__('shop::app.header.wishlist')); ?></span>
                                        </a>
                                    </li>

                                    <li>
                                        <a href="<?php echo e(route('customer.orders.index')); ?>" class="unset">
                                            <i class="icon orders text-down-3"></i>
                                            <span><?php echo e(__('velocity::app.shop.general.orders')); ?></span>
                                        </a>
                                    </li>

                                    <li>
                                        <a href="<?php echo e(route('customer.downloadable_products.index')); ?>" class="unset">
                                            <i class="icon downloadables text-down-3"></i>
                                            <span><?php echo e(__('velocity::app.shop.general.downloadables')); ?></span>
                                        </a>
                                    </li>
                                </ul>
                            <?php endif; ?>

                            <ul type="none" class="meta-wrapper">
                                <li>
                                    <?php if($locale): ?>
                                        <div class="language-logo-wrapper">
                                            <?php if($locale->locale_image): ?>
                                                <img
                                                    class="language-logo"
                                                    src="<?php echo e(asset('/storage/' . $locale->locale_image)); ?>" />
                                            <?php elseif($locale->code == "en"): ?>
                                                <img
                                                    class="language-logo"
                                                    src="<?php echo e(asset('/themes/velocity/assets/images/flags/en.png')); ?>" />
                                            <?php endif; ?>
                                        </div>
                                        <span><?php echo e($locale->name); ?></span>
                                    <?php endif; ?>

                                    <i
                                        class="rango-arrow-right"
                                        @click="toggleMetaInfo('languages')">
                                    </i>
                                </li>

                                <li>
                                    <span><?php echo e($currency->code); ?></span>

                                    <i
                                        class="rango-arrow-right"
                                        @click="toggleMetaInfo('currencies')">
                                    </i>
                                </li>

                                <li>
                                    <?php if(auth()->guard('customer')->check()): ?>
                                        <a
                                            class="unset"
                                            href="<?php echo e(route('customer.session.destroy')); ?>">
                                            <span><?php echo e(__('shop::app.header.logout')); ?></span>
                                        </a>
                                    <?php endif; ?>

                                    <?php if(auth()->guard('customer')->guest()): ?>
                                        <a
                                            class="unset"
                                            href="<?php echo e(route('customer.session.create')); ?>">
                                            <span><?php echo e(__('shop::app.customer.login-form.title')); ?></span>
                                        </a>
                                    <?php endif; ?>
                                </li>
                            </ul>
                        </div>

                        <div class="wrapper" v-else-if="subCategory">
                            <div class="drawer-section">
                                <i class="rango-arrow-left fs24 text-down-4" @click="toggleSubcategories('root')"></i>

                                <h4 class="display-inbl">{{ subCategory.name }}</h4>

                                <i class="material-icons pull-right text-dark" @click="closeDrawer()">
                                    cancel
                                </i>
                            </div>

                            <ul type="none">
                                <li
                                    :key="index"
                                    v-for="(nestedSubCategory, index) in subCategory.children">

                                    <a
                                        class="unset"
                                        :href="`${$root.baseUrl}/${subCategory.slug}/${nestedSubCategory.slug}`">

                                        <div class="category-logo">
                                            <img
                                                class="category-icon"
                                                v-if="nestedSubCategory.category_icon_path"
                                                :src="`${$root.baseUrl}/storage/${nestedSubCategory.category_icon_path}`" />
                                        </div>
                                        <span>{{ nestedSubCategory.name }}</span>
                                    </a>

                                    <ul
                                        type="none"
                                        class="nested-category"
                                        v-if="nestedSubCategory.children && nestedSubCategory.children.length > 0">

                                        <li
                                            :key="`index-${Math.random()}`"
                                            v-for="(thirdLevelCategory, index) in nestedSubCategory.children">
                                            <a
                                                class="unset"
                                                :href="`${$root.baseUrl}/${subCategory.slug}/${nestedSubCategory.slug}/${thirdLevelCategory.slug}`">

                                                <div class="category-logo">
                                                    <img
                                                        class="category-icon"
                                                        v-if="thirdLevelCategory.category_icon_path"
                                                        :src="`${$root.baseUrl}/storage/${thirdLevelCategory.category_icon_path}`" />
                                                </div>
                                                <span>{{ thirdLevelCategory.name }}</span>
                                            </a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </div>

                        <div class="wrapper" v-else-if="languages">
                            <div class="drawer-section">
                                <i class="rango-arrow-left fs24 text-down-4" @click="toggleMetaInfo('languages')"></i>
                                <h4 class="display-inbl"><?php echo e(__('velocity::app.responsive.header.languages')); ?></h4>
                                <i class="material-icons pull-right text-dark" @click="closeDrawer()">cancel</i>
                            </div>

                            <ul type="none">
                                <?php $__currentLoopData = $allLocales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <a
                                            class="unset"
                                            <?php if(isset($serachQuery)): ?>
                                                href="?<?php echo e($serachQuery); ?>&locale=<?php echo e($locale->code); ?>"
                                            <?php else: ?>
                                                href="?locale=<?php echo e($locale->code); ?>"
                                            <?php endif; ?>>

                                            <div class="category-logo">
                                                <img
                                                    class="category-icon"
                                                    src="<?php echo e(asset('/storage/' . $locale->locale_image)); ?>" />
                                            </div>

                                            <span>
                                                <?php echo e(isset($serachQuery) ? $locale->title : $locale->name); ?>

                                            </span>
                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>

                        <div class="wrapper" v-else-if="currencies">
                            <div class="drawer-section">
                                <i class="rango-arrow-left fs24 text-down-4" @click="toggleMetaInfo('currencies')"></i>
                                <h4 class="display-inbl">Currencies</h4>
                                <i class="material-icons pull-right text-dark" @click="closeDrawer()">cancel</i>
                            </div>

                            <ul type="none">
                                <?php $__currentLoopData = $allCurrency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <?php if(isset($serachQuery)): ?>
                                            <a
                                                class="unset"
                                                href="?<?php echo e($serachQuery); ?>&locale=<?php echo e($currency->code); ?>">
                                                <span><?php echo e($currency->code); ?></span>
                                            </a>
                                        <?php else: ?>
                                            <a
                                                class="unset"
                                                href="?locale=<?php echo e($currency->code); ?>">
                                                <span><?php echo e($currency->code); ?></span>
                                            </a>
                                        <?php endif; ?>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>

                    <div class="hamburger-wrapper" @click="toggleHamburger">
                        <i class="rango-toggle hamburger"></i>
                    </div>

                    <logo-component></logo-component>
                </div>

                <div class="right-vc-header col-6">
                    <a
                        class="compare-btn unset"
                        <?php if(auth()->guard('customer')->check()): ?>
                            href="<?php echo e(route('velocity.customer.product.compare')); ?>"
                        <?php endif; ?>

                        <?php if(auth()->guard('customer')->guest()): ?>
                            href="<?php echo e(route('velocity.product.compare')); ?>"
                        <?php endif; ?>
                        >

                        <div class="badge-container" v-if="compareCount > 0">
                            <span class="badge" v-text="compareCount"></span>
                        </div>
                        <i class="material-icons">compare_arrows</i>
                    </a>

                    <a class="wishlist-btn unset" :href="`${isCustomer ? '<?php echo e(route('customer.wishlist.index')); ?>' : '<?php echo e(route('velocity.product.guest-wishlist')); ?>'}`">
                        <div class="badge-container" v-if="wishlistCount > 0">
                            <span class="badge" v-text="wishlistCount"></span>
                        </div>
                        <i class="material-icons">favorite_border</i>
                    </a>

                    <a class="unset cursor-pointer" @click="openSearchBar">
                        <i class="material-icons">search</i>
                    </a>

                    <a href="<?php echo e(route('shop.checkout.cart.index')); ?>" class="unset">
                        <div class="badge-wrapper">
                            <span class="badge">{{ cartItemsCount }}</span>
                        </div>
                        <i class="material-icons text-down-3">shopping_cart</i>
                    </a>
                </div>

                <searchbar-component v-if="isSearchbar"></searchbar-component>
            </div>
        </div>

        <div
            v-else
            @mouseout="toggleSidebar('0', $event, 'mouseout')"
            @mouseover="toggleSidebar('0', $event, 'mouseover')"
            :class="`main-category fs16 unselectable fw6 ${($root.sharedRootCategories.length > 0) ? 'cursor-pointer' : 'cursor-not-allowed'} left`">

            <i class="rango-view-list text-down-4 align-vertical-top fs18">
            </i>
            <span
                class="pl5"
                v-text="heading"
                @mouseover="toggleSidebar('0', $event, 'mouseover')">
            </span>
        </div>

        <div class="content-list right">
            <ul type="none" class="no-margin">
                <li v-for="(content, index) in headerContent" :key="index">
                    <a
                        v-text="content.title"
                        :href="`${$root.baseUrl}/${content['page_link']}`"
                        v-if="(content['content_type'] == 'link' || content['content_type'] == 'category')"
                        :target="content['link_target'] ? '_blank' : '_self'">
                    </a>
                </li>
            </ul>
        </div>
    </header>
</script>

<?php
    $cart = cart()->getCart();

    $cartItemsCount = trans('shop::app.minicart.zero');

    if ($cart) {
        $cartItemsCount = $cart->items->count();
    }
?>

<script type="text/javascript">
    (() => {
        Vue.component('content-header', {
            template: '#content-header-template',
            props: [
                'heading',
                'headerContent',
            ],

            data: function () {
                return {
                    'compareCount': 0,
                    'wishlistCount': 0,
                    'languages': false,
                    'hamburger': false,
                    'currencies': false,
                    'subCategory': null,
                    'isSearchbar': false,
                    'rootCategories': true,
                    'cartItemsCount': '<?php echo e($cartItemsCount); ?>',
                    'isCustomer': '<?php echo e(auth()->guard('customer')->user() ? "true" : "false"); ?>' == "true",
                }
            },

            watch: {
                hamburger: function (value) {
                    if (value) {
                        document.body.classList.add('open-hamburger');
                    } else {
                        document.body.classList.remove('open-hamburger');
                    }
                },

                '$root.headerItemsCount': function () {
                    this.updateHeaderItemsCount();
                },

                '$root.miniCartKey': function () {
                    this.getMiniCartDetails();
                }
            },

            created: function () {
                this.getMiniCartDetails();
                this.updateHeaderItemsCount();
            },

            methods: {
                openSearchBar: function () {
                    this.isSearchbar = !this.isSearchbar;

                    let footer = $('.footer');
                    let homeContent = $('#home-right-bar-container');

                    if (this.isSearchbar) {
                        footer[0].style.opacity = '.3';
                        homeContent[0].style.opacity = '.3';
                    } else {
                        footer[0].style.opacity = '1';
                        homeContent[0].style.opacity = '1';
                    }
                },

                toggleHamburger: function () {
                    this.hamburger = !this.hamburger;
                },

                closeDrawer: function() {
                    $('.nav-container').hide();

                    this.toggleHamburger();
                    this.rootCategories = true;
                },

                toggleSubcategories: function (index, event) {
                    if (index == "root") {
                        this.rootCategories = true;
                        this.subCategory = false;
                    } else {
                        event.preventDefault();

                        let categories = this.$root.sharedRootCategories;
                        this.rootCategories = false;
                        this.subCategory = categories[index];
                    }
                },

                toggleMetaInfo: function (metaKey) {
                    this.rootCategories = ! this.rootCategories;
                    
                    this[metaKey] = !this[metaKey];
                },

                updateHeaderItemsCount: function () {
                    if (! this.isCustomer) {
                        let comparedItems = this.getStorageValue('compared_product');
                        let wishlistedItems = this.getStorageValue('wishlist_product');

                        if (wishlistedItems) {
                            this.wishlistCount = wishlistedItems.length;
                        }

                        if (comparedItems) {
                            this.compareCount = comparedItems.length;
                        }
                    } else {
                        this.$http.get(`${this.$root.baseUrl}/items-count`)
                            .then(response => {
                                this.compareCount = response.data.compareProductsCount;
                                this.wishlistCount = response.data.wishlistedProductsCount;
                            })
                            .catch(exception => {
                                console.log(this.__('error.something_went_wrong'));
                            });
                    }
                },

                getMiniCartDetails: function () {
                    this.$http.get(`${this.$root.baseUrl}/mini-cart`)
                    .then(response => {
                        if (response.data.status) {
                            this.cartItemsCount = response.data.mini_cart.cart_items.length;
                        }
                    })
                    .catch(exception => {
                        console.log(this.__('error.something_went_wrong'));
                    });
                },
            },
        });
    })()
</script><?php /**PATH C:\xampp\htdocs\laravel\bagisto/resources/themes/velocity/views/UI/header.blade.php ENDPATH**/ ?>