<?php

return [
    'save' => 'Save',
    'create' => 'Create',
    'update' => 'Update',
    'delete' => 'Delete',
    'failed' => 'Failed',
    'store' => 'Store',
    'image' => 'Image',
    'no result' => 'No result',
    'product' => 'Product',
    'attribute' => 'Attribute',
    'actions' => 'Actions',
    'id' => 'ID',
    'action' => 'action',
    'yes' => 'Yes',
    'no' => 'No',
    'true' => 'True',
    'false' => 'False',
    'apply' => 'Apply',
    'action' => 'Action',
    'label' => 'Label',
    'name' => 'Name',
    'title' => 'Title',
    'code' => 'Code',
    'type' => 'Type',
    'required' => 'Required',
    'unique' => 'Unique',
    'locale-based' => 'Locale based',
    'channel-based' => 'Channel based',
    'status' => 'Status',
    'select-option' => 'Select option',
    'category' => 'Category',

    'common' => [
        'no-result-found' => 'We could not find any records.',
        'country' => 'Country',
        'state' => 'State',
        'true' => 'True',
        'false' => 'False'
    ],

    'layouts' => [
        'my-account' => 'My Account',
        'logout' => 'Logout',
        'visit-shop' => 'Visit Shop',
        'dashboard' => 'Dashboard',
        'sales' => 'Sales',
        'orders' => 'Orders',
        'shipments' => 'Shipments',
        'invoices' => 'Invoices',
        'refunds' => 'Refunds',
        'catalog' => 'Catalog',
        'products' => 'Products',
        'categories' => 'Categories',
        'attributes' => 'Attributes',
        'attribute-families' => 'Attribute Families',
        'customers' => 'Customers',
        'groups' => 'Groups',
        'reviews' => 'Reviews',
        'newsletter-subscriptions' => 'Newsletter Subscriptions',
        'configure' => 'Configure',
        'settings' => 'Settings',
        'locales' => 'Locales',
        'currencies' => 'Currencies',
        'exchange-rates' => 'Exchange Rates',
        'inventory-sources' => 'Inventory Sources',
        'channels' => 'Channels',
        'users' => 'Users',
        'roles' => 'Roles',
        'sliders' => 'Sliders',
        'taxes' => 'Taxes',
        'tax-categories' => 'Tax Categories',
        'tax-rates' => 'Tax Rates',
        'promotions' => 'Promotions',
        'discount' => 'Discount',
        'cms' => 'CMS'
    ],

    'acl' => [
        'dashboard' => 'Dashboard',
        'sales' => 'Sales',
        'orders' => 'Orders',
        'shipments' => 'Shipments',
        'invoices' => 'Invoices',
        'catalog' => 'Catalog',
        'products' => 'Products',
        'categories' => 'Categories',
        'attributes' => 'Attributes',
        'attribute-families' => 'Attribute Families',
        'customers' => 'Customers',
        'groups' => 'Groups',
        'reviews' => 'Reviews',
        'newsletter-subscriptions' => 'Newsletter Subscriptions',
        'configure' => 'Configure',
        'settings' => 'Settings',
        'locales' => 'Locales',
        'currencies' => 'Currencies',
        'exchange-rates' => 'Exchange Rates',
        'inventory-sources' => 'Inventory Sources',
        'channels' => 'Channels',
        'users' => 'Users',
        'roles' => 'Roles',
        'sliders' => 'Sliders',
        'taxes' => 'Taxes',
        'tax-categories' => 'Tax Categories',
        'tax-rates' => 'Tax Rates',
        'edit' => 'Edit',
        'create' => 'Add',
        'delete' => 'Delete',
        'promotions' => 'Promotions',
        'cart-rules' => 'Cart Rules',
        'catalog-rules' => 'Catalog Rules',
    ],

    'dashboard' => [
        'title' => 'Dashboard',
        'from' => 'From',
        'to' => 'To',
        'total-customers' => 'Total Customers',
        'total-orders' => 'Total Orders',
        'total-sale' => 'Total Sale',
        'average-sale' => 'Average Order Sale',
        'increased' => ':progress%',
        'decreased' => ':progress%',
        'sales' => 'Sales',
        'top-performing-categories' => 'Top Performing Categories',
        'product-count' => ':count Products',
        'top-selling-products' => 'Top Selling Products',
        'sale-count' => ':count Sales',
        'customer-with-most-sales' => 'Customer With Most Sales',
        'order-count' => ':count Orders',
        'revenue' => 'Revenue :total',
        'stock-threshold' => 'Stock Threshold',
        'qty-left' => ':qty Left'
    ],

    'datagrid' => [
        'mass-ops' => [
            'method-error' => 'Error! Wrong method detected, please check mass action configuration',
            'delete-success' => 'Selected :resource were successfully deleted',
            'partial-action' => 'Some actions were not performed due restricted system constraints on :resource',
            'update-success' => 'Selected :resource were successfully updated',
            'no-resource' => 'The resource provided for insufficient for the action'
        ],

        'id' => 'ID',
        'status' => 'Status',
        'code' => 'Code',
        'admin-name' => 'Name',
        'name' => 'Name',
        'direction' => 'Direction',
        'fullname' => 'Full Name',
        'type' => 'Type',
        'required' => 'Required',
        'unique' => 'Unique',
        'per-locale' => 'Locale Based',
        'per-channel' => 'Channel Based',
        'position' => 'Position',
        'locale' => 'Locale',
        'hostname' => 'Hostname',
        'email' => 'Email',
        'group' => 'Group',
        'phone' => 'Phone',
        'gender' => 'Gender',
        'title' => 'Title',
        'layout' => 'Layout',
        'url-key' => 'URL Key',
        'comment' => 'Comment',
        'product-name' => 'Product',
        'currency-name' => 'Currency Name',
        'exch-rate' => 'Exchange Rate',
        'priority' => 'Priority',
        'subscribed' => 'Subscribed',
        'base-total' => 'Base Total',
        'grand-total' => 'Grand Total',
        'order-date' => 'Order Date',
        'channel-name' => 'Channel Name',
        'billed-to' => 'Billed To',
        'shipped-to' => 'Shipped To',
        'order-id' => 'Order Id',
        'invoice-date' => 'Invoice Date',
        'total-qty' => 'Total Qty',
        'inventory-source' => 'Inventory Source',
        'shipment-date' => 'Shipment Date',
        'shipment-to' => 'Shipping To',
        'sku' => 'SKU',
        'price' => 'Price',
        'qty' => 'Quantity',
        'permission-type' => 'Permission Type',
        'identifier' => 'Identifier',
        'state' => 'State',
        'country' => 'Country',
        'tax-rate' => 'Rate',
        'role' => 'Role',
        'sub-total' => 'Sub Total',
        'no-of-products' => 'Number of Products',
        'attribute-family' => 'Attribute Family',
        'starts-from' => 'Starts From',
        'ends-till' => 'Ends Till',
        'per-cust' => 'Per Customer',
        'usage-throttle' => 'Usage Times',
        'for-guest' => 'For Guest',
        'order_number' => 'Order Number',
        'refund-date' => 'Refund Date',
        'refunded' => 'Refunded',
        'start' => 'Start',
        'end' => 'End',
        'active' => 'Active',
        'inactive' => 'Inactive',
        'true' => 'True',
        'false' => 'False',
        'approved' => 'Approved',
        'pending' => 'Pending',
        'disapproved' => 'Disapproved',
        'coupon-code' => 'Coupon Code',
        'times-used' => 'Times Used',
        'created-date' => 'Created Date',
        'expiration-date' => 'Expiration Date',
        'edit' => 'Edit',
        'delete' => 'Delete',
        'view' => 'View',
        'rtl' => 'RTL',
        'ltr' => 'LTR',
        'update-status' => 'Update Status'
    ],

    'account' => [
        'title' => 'My Account',
        'save-btn-title' => 'Save',
        'general' => 'General',
        'name' => 'Name',
        'email' => 'Email',
        'password' => 'Password',
        'confirm-password' => 'Confirm Password',
        'change-password' => 'Change Account Password',
        'current-password' => 'Current Password'
    ],

    'users' => [
        'forget-password' => [
            'title' => 'Forget Password',
            'header-title' => 'Recover Password',
            'email' => 'Registered Email',
            'password' => 'Password',
            'confirm-password' => 'Confirm Password',
            'back-link-title' => 'Back to Sign In',
            'submit-btn-title' => 'Send Password Reset Email'
        ],

        'reset-password' => [
            'title' => 'Reset Password',
            'email' => 'Registered Email',
            'password' => 'Password',
            'confirm-password' => 'Confirm Password',
            'back-link-title' => 'Back to Sign In',
            'submit-btn-title' => 'Reset Password'
        ],

        'roles' => [
            'title' => 'Roles',
            'add-role-title' => 'Add Role',
            'edit-role-title' => 'Edit Role',
            'save-btn-title' => 'Save Role',
            'general' => 'General',
            'name' => 'Name',
            'description' => 'Description',
            'access-control' => 'Access Control',
            'permissions' => 'Permissions',
            'custom' => 'Custom',
            'all' => 'All'
        ],

        'users' => [
            'title' => 'User',
            'add-user-title' => 'Add User',
            'edit-user-title' => 'Edit User',
            'save-btn-title' => 'Save User',
            'general' => 'General',
            'email' => 'Email',
            'name' => 'Name',
            'password' => 'Password',
            'confirm-password' => 'Confirm Password',
            'status-and-role' => 'Status and Role',
            'role' => 'Role',
            'status' => 'Status',
            'account-is-active' => 'Account is Active',
            'current-password' => 'Enter Current Password',
            'confirm-delete' => 'Confirm Delete This Account',
            'confirm-delete-title' => 'Confirm password before delete',
            'delete-last' => 'At least one admin is required.',
            'delete-success' => 'Success! User deleted',
            'incorrect-password' => 'The password you entered is incorrect',
            'password-match' => 'Current password does not match.',
            'account-save' => 'Account changes saved successfully.',
            'login-error' => 'Please check your credentials and try again.',
            'activate-warning' => 'Your account is yet to be activated, please contact administrator.'
        ],

        'sessions' => [
            'title' => 'Sign In',
            'email' => 'Email',
            'password' => 'Password',
            'forget-password-link-title' => 'Forget Password ?',
            'remember-me' => 'Remember Me',
            'submit-btn-title' => 'Sign In'
        ]
    ],

    'sales' => [
        'orders' => [
            'title' => 'Orders',
            'view-title' => 'Order #:order_id',
            'cancel-btn-title' => 'Cancel',
            'shipment-btn-title' => 'Ship',
            'invoice-btn-title' => 'Invoice',
            'info' => 'Information',
            'invoices' => 'Invoices',
            'shipments' => 'Shipments',
            'order-and-account' => 'Order and Account',
            'order-info' => 'Order Information',
            'order-date' => 'Order Date',
            'order-status' => 'Order Status',
            'order-status-canceled' => 'Canceled',
            'order-status-closed' => 'Closed',
            'order-status-fraud' => 'Fraud',
            'order-status-pending' => 'Pending',
            'order-status-pending-payment' => 'Pending Payment',
            'order-status-processing' => 'Processing',
            'order-status-success' => 'Completed',
            'channel' => 'Channel',
            'customer-name' => 'Customer Name',
            'email' => 'Email',
            'contact-number' => 'Contact Number',
            'account-info' => 'Account Information',
            'address' => 'Address',
            'shipping-address' => 'Shipping Address',
            'billing-address' => 'Billing Address',
            'payment-and-shipping' => 'Payment and Shipping',
            'payment-info' => 'Payment Information',
            'payment-method' => 'Payment Method',
            'currency' => 'Currency',
            'shipping-info' => 'Shipping Information',
            'shipping-method' => 'Shipping Method',
            'shipping-price' => 'Shipping Price',
            'products-ordered' => 'Products Ordered',
            'SKU' => 'SKU',
            'product-name' => 'Product Name',
            'qty' => 'Qty',
            'item-status' => 'Item Status',
            'item-ordered' => 'Ordered (:qty_ordered)',
            'item-invoice' => 'Invoiced (:qty_invoiced)',
            'item-shipped' => 'Shipped (:qty_shipped)',
            'item-canceled' => 'Canceled (:qty_canceled)',
            'item-refunded' => 'Refunded (:qty_refunded)',
            'price' => 'Price',
            'total' => 'Total',
            'subtotal' => 'Subtotal',
            'shipping-handling' => 'Shipping & Handling',
            'discount' => 'Discount',
            'tax' => 'Tax',
            'tax-percent' => 'Tax Percent',
            'tax-amount' => 'Tax Amount',
            'discount-amount' => 'Discount Amount',
            'discount-amount' => 'Discount Amount',
            'grand-total' => 'Grand Total',
            'total-paid' => 'Total Paid',
            'total-refunded' => 'Total Refunded',
            'total-due' => 'Total Due',
            'cancel-confirm-msg' => 'Are you sure you want to cancel this order ?',
            'refund-btn-title' => 'Refund',
            'refunds' => 'Refunds'
        ],

        'invoices' => [
            'title' => 'Invoices',
            'id' => 'Id',
            'invoice-id' => 'Invoice Id',
            'date' => 'Invoice Date',
            'order-id' => 'Order Id',
            'customer-name' => 'Customer Name',
            'status' => 'Status',
            'amount' => 'Amount',
            'action' => 'Action',
            'add-title' => 'Create Invoice',
            'save-btn-title' => 'Save Invoice',
            'qty' => 'Qty',
            'qty-ordered' => 'Qty Ordered',
            'qty-to-invoice' => 'Qty to Invoice',
            'view-title' => 'Invoice #:invoice_id',
            'bill-to' => 'Bill to',
            'ship-to' => 'Ship to',
            'print' => 'Print',
            'order-date' => 'Order Date',
            'creation-error' => 'Order invoice creation is not allowed.',
            'product-error' => 'Invoice can not be created without products.'
        ],

        'shipments' => [
            'title' => 'Shipments',
            'id' => 'Id',
            'date' => 'Shipment Date',
            'order-id' => 'Order Id',
            'order-date' => 'Order date',
            'customer-name' => 'Customer Name',
            'total-qty' => 'Total Qty',
            'action' => 'Action',
            'add-title' => 'Create Shipment',
            'save-btn-title' => 'Save Shipment',
            'qty-ordered' => 'Qty Ordered',
            'qty-invoiced' => 'Qty Invoiced',
            'qty-to-ship' => 'Qty to Ship',
            'available-sources' => 'Available Sources',
            'source' => 'Source',
            'select-source' => 'Please Select Source',
            'qty-available' => 'Qty Available',
            'inventory-source' => 'Inventory Source',
            'carrier-title' => 'Carrier Title',
            'tracking-number' => 'Tracking Number',
            'view-title' => 'Shipment #:shipment_id',
            'creation-error' => 'Shipment can not be created for this order.',
            'order-error' => 'Order shipment creation is not allowed.',
            'quantity-invalid' => 'Requested quantity is invalid or not available.',
        ],

        'refunds' => [
            'title' => 'Refunds',
            'id' => 'Id',
            'add-title' => 'Create Refund',
            'save-btn-title' => 'Refund',
            'order-id' => 'Order Id',
            'qty-ordered' => 'Qty Ordered',
            'qty-to-refund' => 'Qty To Refund',
            'refund-shipping' => 'Refund Shipping',
            'adjustment-refund' => 'Adjustment Refund',
            'adjustment-fee' => 'Adjustment Fee',
            'update-qty' => 'Update Quantities',
            'invalid-qty' => 'We found an invalid quantity to refund items.',
            'refund-limit-error' => 'The most money available to refund is :amount.',
            'refunded' => 'Refunded',
            'date' => 'Refund Date',
            'customer-name' => 'Customer Name',
            'status' => 'Status',
            'action' => 'Action',
            'view-title' => 'Refund #:refund_id',
            'invalid-refund-amount-error' => 'Refund amount should be non zero.'

        ]
    ],

    'catalog' => [
        'products' => [
            'title' => 'Products',
            'add-product-btn-title' => 'Add Product',
            'add-title' => 'Add Product',
            'edit-title' => 'Edit Product',
            'save-btn-title' => 'Save Product',
            'general' => 'General',
            'product-type' => 'Product Type',
            'simple' => 'Simple',
            'configurable' => 'Configurable',
            'familiy' => 'Attribute Family',
            'sku' => 'SKU',
            'configurable-attributes' => 'Configurable Attributes',
            'attribute-header' => 'Attribute(s)',
            'attribute-option-header' => 'Attribute Option(s)',
            'no' => 'No',
            'yes' => 'Yes',
            'disabled' => 'Disabled',
            'enabled' => 'Enabled',
            'add-variant-btn-title' => 'Add Variant',
            'name' => 'Name',
            'qty' => 'Qty',
            'price' => 'Price',
            'weight' => 'Weight',
            'status' => 'Status',
            'enabled' => 'Enabled',
            'disabled' => 'Disabled',
            'add-variant-title' => 'Add Variant',
            'variant-already-exist-message' => 'Variant with same attribute options already exists.',
            'add-image-btn-title' => 'Add Image',
            'mass-delete-success' => 'All the selected products have been deleted successfully',
            'mass-update-success' => 'All the selected products have been updated successfully',
            'configurable-error' => 'Please select atleast one configurable attribute.',
            'categories' => 'Categories',
            'images' => 'Images',
            'inventories' => 'Inventories',
            'variations' => 'Variations',
            'downloadable' => 'Downloadable Information',
            'links' => 'Links',
            'add-link-btn-title' => 'Add Link',
            'samples' => 'Samples',
            'add-sample-btn-title' => 'Add Sample',
            'downloads' => 'Download Allowed',
            'file' => 'File',
            'sample' => 'Sample',
            'upload-file' => 'Upload File',
            'url' => 'Url',
            'sort-order' => 'Sort Order',
            'browse-file' => 'Browse File',
            'product-link' => 'Linked Products',
            'cross-selling' => 'Cross Selling',
            'up-selling' => 'Up Selling',
            'related-products' => 'Related Products',
            'product-search-hint' => 'Start typing product name',
            'no-result-found' => 'Products not found with same name.',
            'searching' => 'Searching ...',
            'grouped-products' => 'Grouped Products',
            'search-products' => 'Search Products',
            'no-result-found' => 'Products not found with same name.',
            'channel' => 'Channels',
            'bundle-items' => 'Bundle Items',
            'add-option-btn-title' => 'Add Option',
            'option-title' => 'Option Title',
            'input-type' => 'Input Type',
            'is-required' => 'Is Required',
            'select' => 'Select',
            'radio' => 'Radio',
            'checkbox' => 'Checkbox',
            'multiselect' => 'Multiselect',
            'new-option' => 'New Option',
            'is-default' => 'Is Default'
        ],

        'attributes' => [
            'title' => 'Attributes',
            'add-title' => 'Add Attribute',
            'edit-title' => 'Edit Attribute',
            'save-btn-title' => 'Save Attribute',
            'general' => 'General',
            'code' => 'Attribute Code',
            'type' => 'Attribute Type',
            'text' => 'Text',
            'textarea' => 'Textarea',
            'price' => 'Price',
            'boolean' => 'Boolean',
            'select' => 'Select',
            'multiselect' => 'Multiselect',
            'datetime' => 'Datetime',
            'date' => 'Date',
            'label' => 'Label',
            'admin' => 'Admin',
            'options' => 'Options',
            'position' => 'Position',
            'add-option-btn-title' => 'Add Option',
            'validations' => 'Validations',
            'input_validation' => 'Input Validation',
            'is_required' => 'Is Required',
            'is_unique' => 'Is Unique',
            'number' => 'Number',
            'decimal' => 'Decimal',
            'email' => 'Email',
            'url' => 'URL',
            'configuration' => 'Configuration',
            'status' => 'Status',
            'yes' => 'Yes',
            'no' => 'No',
            'value_per_locale' => 'Value Per Locale',
            'value_per_channel' => 'Value Per Channel',
            'value_per_channel' => 'Value Per Channel',
            'is_filterable' => 'Use in Layered Navigation',
            'is_configurable' => 'Use To Create Configurable Product',
            'admin_name' => 'Admin Name',
            'is_visible_on_front' => 'Visible on Product View Page on Front-end',
            'swatch_type' => 'Swatch Type',
            'dropdown' => 'Dropdown',
            'color-swatch' => 'Color Swatch',
            'image-swatch' => 'Image Swatch',
            'text-swatch' => 'Text Swatch',
            'swatch' => 'Swatch',
            'image' => 'Image',
            'file' => 'File',
            'checkbox' => 'Checkbox',
            'use_in_flat' => "Create in Product Flat Table",
            'is_comparable' => "Attribute is comparable",
            'default_null_option' => 'Create default empty option',
        ],
        'families' => [
            'title' => 'Families',
            'add-family-btn-title' => 'Add Family',
            'add-title' => 'Add Family',
            'edit-title' => 'Edit Family',
            'save-btn-title' => 'Save Family',
            'general' => 'General',
            'code' => 'Family Code',
            'name' => 'Name',
            'groups' => 'Groups',
            'add-group-title' => 'Add Group',
            'position' => 'Position',
            'attribute-code' => 'Code',
            'type' => 'Type',
            'add-attribute-title' => 'Add Attributes',
            'search' => 'Search',
            'group-exist-error' => 'Group with same name already exists.'
        ],
        'categories' => [
            'title' => 'Categories',
            'add-title' => 'Add Category',
            'edit-title' => 'Edit Category',
            'save-btn-title' => 'Save Category',
            'general' => 'General',
            'name' => 'Name',
            'visible-in-menu' => 'Visible In Menu',
            'yes' => 'Yes',
            'no' => 'No',
            'position' => 'Position',
            'display-mode' => 'Display Mode',
            'products-and-description' => 'Products and Description',
            'products-only' => 'Products Only',
            'description-only' => 'Description Only',
            'description-and-images' => 'Description and Images',
            'description' => 'Description',
            'parent-category' => 'Parent Category',
            'seo' => 'Search Engine Optimization',
            'slug' => 'Slug',
            'meta_title' => 'Meta Title',
            'meta_description' => 'Meta Description',
            'meta_keywords' => 'Meta Keywords',
            'image' => 'Image',
            'filterable-attributes' => 'Filterable Attributes',
            'attributes' => 'Attributes',
        ]
    ],

    'configuration' => [
        'title' => 'Configuration',
        'save-btn-title' => 'Save',
        'save-message' => 'Configuration saved successfully',
        'yes' => 'Yes',
        'no' => 'No',
        'delete' => 'Delete',

        'tax-categories' => [
            'title' => 'Tax Categories',
            'add-title' => 'Add Tax Category',
            'edit-title' => 'Edit Tax Category',
            'save-btn-title' => 'Save Tax Category',
            'general' => 'Tax Category',
            'select-channel' => 'Select Channel',
            'name' => 'Name',
            'code' => 'Code',
            'description' => 'Description',
            'select-taxrates' => 'Select Tax Rates',
            'edit' => [
                'title' => 'Edit Tax Category',
                'edit-button-title' => 'Edit Tax Category'
            ]
        ],

        'tax-rates' => [
            'title' => 'Tax Rates',
            'add-title' => 'Add Tax Rate',
            'edit-title' => 'Edit Tax Rate',
            'save-btn-title' => 'Save Tax Rate',
            'general' => 'Tax Rate',
            'identifier' => 'Identifier',
            'is_zip' => 'Enable Zip Range',
            'zip_from' => 'Zip From',
            'zip_to' => 'Zip To',
            'state' => 'State',
            'select-state' => 'Select a region, state or province.',
            'country' => 'Country',
            'tax_rate' => 'Rate',
            'edit' => [
                'title' => 'Edit Tax Rate',
                'edit-button-title' => 'Edit Rate'
            ],
            'zip_code' => 'Zip Code',
            'is_zip' => 'Enable Zip Range',
        ],

        'sales' => [
            'shipping-method' => [
                'title' => 'Shipping Methods',
                'save-btn-title' => 'Save',
                'description' => 'Description',
                'active' => 'Active',
                'status' => 'Status'
            ]
        ]
    ],

    'settings' => [
        'locales' => [
            'title' => 'Locales',
            'add-title' => 'Add Locale',
            'edit-title' => 'Edit Locale',
            'add-title' => 'Add Locale',
            'save-btn-title' => 'Save Locale',
            'general' => 'General',
            'code' => 'Code',
            'name' => 'Name',
            'direction' => 'Direction',
            'create-success' => 'Locale created successfully.',
            'update-success' => 'Locale updated successfully.',
            'delete-success' => 'Locale deleted successfully.',
            'last-delete-error' => 'At least one Locale is required.',
        ],
        'countries' => [
            'title' => 'Countries',
            'add-title' => 'Add Country',
            'save-btn-title' => 'Save Country',
            'general' => 'General',
            'code' => 'Code',
            'name' => 'Name'
        ],
        'currencies' => [
            'title' => 'Currencies',
            'add-title' => 'Add Currency',
            'edit-title' => 'Edit Currency',
            'save-btn-title' => 'Save Currency',
            'general' => 'General',
            'code' => 'Code',
            'name' => 'Name',
            'symbol' => 'Symbol',
            'create-success' => 'Currency created successfully.',
            'update-success' => 'Currency updated successfully.',
            'delete-success' => 'Currency deleted successfully.',
            'last-delete-error' => 'At least one Currency is required.',
        ],
        'exchange_rates' => [
            'title' => 'Exchange Rates',
            'add-title' => 'Add Exchange Rate',
            'edit-title' => 'Edit Exchange Rate',
            'save-btn-title' => 'Save Exchange Rate',
            'general' => 'General',
            'source_currency' => 'Source Currency',
            'target_currency' => 'Target Currency',
            'rate' => 'Rate',
            'exchange-class-not-found' => ':service exchange rate class not found',
            'update-rates' => 'Update Rates',
            'create-success' => 'Exchange Rate created successfully.',
            'update-success' => 'Exchange Rate updated successfully.',
            'delete-success' => 'Exchange Rate deleted successfully.',
            'last-delete-error' => 'At least one Exchange Rate is required.',
        ],
        'inventory_sources' => [
            'title' => 'Inventory Sources',
            'add-title' => 'Add Inventory Source',
            'edit-title' => 'Edit Inventory Source',
            'save-btn-title' => 'Save Inventory Source',
            'general' => 'General',
            'code' => 'Code',
            'name' => 'Name',
            'description' => 'Description',
            'source-is-active' => 'Source is Active',
            'contact-info' => 'Contact Information',
            'contact_name' => 'Name',
            'contact_email' => 'Email',
            'contact_number' => 'Contact Number',
            'contact_fax' => 'Fax',
            'address' => 'Source Address',
            'country' => 'Country',
            'state' => 'State',
            'city' => 'City',
            'street' => 'Street',
            'postcode' => 'Postcode',
            'priority' => 'Priority',
            'latitude' => 'Latitude',
            'longitude' => 'Longitude',
            'status' => 'Status',
            'create-success' => 'Inventory source created successfully.',
            'update-success' => 'Inventory source updated successfully.',
            'delete-success' => 'Inventory source deleted successfully.',
            'last-delete-error' => 'At least one Inventory source is required.',
        ],
        'channels' => [
            'title' => 'Channels',
            'add-title' => 'Add Channel',
            'edit-title' => 'Edit Channel',
            'save-btn-title' => 'Save Channel',
            'general' => 'General',
            'code' => 'Code',
            'name' => 'Name',
            'description' => 'Description',
            'hostname' => 'Hostname',
            'currencies-and-locales' => 'Currencies and Locales',
            'locales' => 'Locales',
            'default-locale' => 'Default Locale',
            'currencies' => 'Currencies',
            'base-currency' => 'Default Currency',
            'root-category' => 'Root Category',
            'inventory_sources' => 'Inventory Sources',
            'design' => 'Design',
            'theme' => 'Theme',
            'home_page_content' => 'Home Page Content',
            'footer_content' => 'Footer Content',
            'logo' => 'Logo',
            'favicon' => 'Favicon',
            'create-success' => 'Channel created successfully.',
            'update-success' => 'Channel updated successfully.',
            'delete-success' => 'Channel deleted successfully.',
            'last-delete-error' => 'At least one Channel is required.',
            'seo' => 'Home page SEO',
            'seo-title' => 'Meta title',
            'seo-description' => 'Meta description',
            'seo-keywords' => 'Meta keywords',

        ],

        'sliders' => [
            'title' => 'Sliders',
            'name' => 'Name',
            'add-title' => 'Create Slider',
            'edit-title' => 'Edit Slider',
            'save-btn-title' => 'Save Slider',
            'general' => 'General',
            'image' => 'Image',
            'content' => 'Content',
            'channels' => 'Channel',
            'created-success' => 'Slider item created successfully',
            'created-fault' => 'Error in creating slider item',
            'update-success' => 'Slider item successfully updated',
            'update-fail' => 'Slider cannot be updated',
            'delete-success' => 'Cannot delete last llider item',
            'delete-fail' => 'Slider item successfully deleted'
        ],

        'tax-categories' => [
            'title' => 'Tax Categories',
            'add-title' => 'Create Tax Category',
            'edit-title' => 'Edit Tax Category',
            'save-btn-title' => 'Save Tax Category',
            'general' => 'Tax Category',
            'select-channel' => 'Select Channel',
            'name' => 'Name',
            'code' => 'Code',
            'description' => 'Description',
            'select-taxrates' => 'Select Tax Rates',
            'edit' => [
                'title' => 'Edit Tax Category',
                'edit-button-title' => 'Edit Tax Category'
            ],
            'create-success' => 'New Tax Category Created',
            'create-error' => 'Error, While Creating Tax Category',
            'update-success' => 'Successfully Updated Tax Category',
            'update-error' => 'Error While Updating Tax Category',
            'atleast-one' => 'Cannot Delete The Last Tax Category',
            'delete' => 'Tax Category Successfully Deleted'
        ],

        'tax-rates' => [
            'title' => 'Tax Rates',
            'add-title' => 'Create Tax Rate',
            'edit-title' => 'Edit Tax Rate',
            'save-btn-title' => 'Save Tax Rate',
            'general' => 'Tax Rate',
            'identifier' => 'Identifier',
            'is_zip' => 'Enable Zip Range',
            'zip_from' => 'Zip From',
            'zip_to' => 'Zip To',
            'state' => 'State',
            'select-state' => 'Select a region, state or province.',
            'country' => 'Country',
            'tax_rate' => 'Rate',
            'edit' => [
                'title' => 'Edit Tax Rate',
                'edit-button-title' => 'Edit Rate'
            ],
            'zip_code' => 'Zip Code',
            'is_zip' => 'Enable Zip Range',
            'create-success' => 'Tax Rate Created Successfully',
            'create-error' => 'Cannot Create Tax Rate',
            'update-success' => 'Tax Rate Updated Successfully',
            'update-error' => 'Error! Tax Rate Cannot Be Updated',
            'delete' => 'Tax Rate Deleted Successfully',
            'atleast-one' => 'Cannot Delete Last Tax Rate'
        ],
        'development' => [
            'title' => 'Development',
        ]
    ],

    'customers' => [
        'groups' =>[
            'add-title' => 'Add Group',
            'edit-title' => 'Edit Group',
            'save-btn-title' => 'Save Group',
            'title' => 'Groups',
            'save-btn-title' => 'Save Group',
            'code' => 'Code',
            'name' => 'Name',
            'is_user_defined' => 'User Defined',
            'yes' => 'Yes'
        ],

        'addresses' => [
            'title' => ':customer_name\'s Addresses List',
            'vat_id' => 'Vat id',
            'create-title' => 'Create Customer\'s Address',
            'edit-title' => 'Update Customer\'s Address',
            'title-orders' => ':customer_name\'s Orders List',
            'address-list' => 'Address\'s List',
            'order-list' => 'Order\'s List',
            'address-id' => 'Address ID',
            'address-1' => 'Address 1',
            'city' => 'City',
            'state-name' => 'State',
            'country-name' => 'Country',
            'postcode' => 'Post Code',
            'default-address' => 'Default Address',
            'yes' => 'Yes',
            'not-approved' => 'Not Approved',
            'no' => 'No',
            'dash' => '-',
            'delete' => 'Delete',
            'create-btn-title' => 'Add Address',
            'save-btn-title' => 'Save Address',
            'general' => 'General',
            'success-create' => 'Success: Customer address created successfully.',
            'success-update' => 'Success: Customer address updated successfully.',
            'success-delete' => 'Success: Customer address deleted successfully.',
            'success-mass-delete' => 'Success: selected addresses deleted successfully.',
            'error-create' => 'Error: Customer address not created.',
        ],

        'note' => [
            'title' => 'Add Note',
            'save-note' => 'Save Note',
            'enter-note' => 'Enter Note',
            'help-title' => 'Add Note On This Customer'
        ],

        'customers' => [
            'add-title' => 'Add Customer',
            'edit-title' => 'Edit Customer',
            'title' => 'Customers',
            'first_name' => 'First Name',
            'last_name' => 'Last Name',
            'gender' => 'Gender',
            'email' => 'Email',
            'date_of_birth' => 'Date of Birth',
            'phone' => 'Phone',
            'customer_group' => 'Customer Group',
            'save-btn-title' => 'Save Customer',
            'channel_name' => 'Channel Name',
            'state' => 'State',
            'select-state' => 'Select a region, state or province.',
            'country' => 'Country',
            'other' => 'Other',
            'male' => 'Male',
            'female' => 'Female',
            'phone' => 'Phone',
            'group-default' => 'Cannot delete the default group.',
            'edit-help-title' => 'Edit Customer',
            'delete-help-title' => 'Delete Customer',
            'addresses' => 'Addresses',
            'mass-destroy-success' => 'Customers deleted successfully',
            'mass-update-success' => 'Customers updated successfully',
            'status' => 'Status',
            'active' => 'Active',
            'inactive' => 'Inactive'
        ],

        'reviews' => [
            'title' => 'Reviews',
            'edit-title' => 'Edit Review',
            'rating' => 'Rating',
            'status' => 'Status',
            'comment' => 'Comment',
            'pending' => 'Pending',
            'approved' => 'Approve',
            'disapproved' => 'Disapprove'
        ],

        'subscribers' => [
            'title' => 'News Letter Subscribers',
            'title-edit' => 'Edit News Letter Subscriber',
            'email' => 'Email',
            'is_subscribed' => 'Subscribed',
            'edit-btn-title' => 'Update Subscriber',
            'update-success' => 'Subscriber was successfully updated',
            'update-failed' => 'Error! You cannot unsubscribe the subscriber',
            'delete' => 'Subscriber was successfully deleted',
            'delete-failed' => 'Error! Subscriber cannot be deleted'
        ]
    ],

    'promotions' => [
        'cart-rules' => [
            'title' => 'Cart Rules',
            'add-title' => 'Add Cart Rule',
            'edit-title' => 'Edit Cart Rule',
            'save-btn-title' => 'Save Cart Rule',
            'rule-information' => 'Rule Information',
            'name' => 'Name',
            'description' => 'Description',
            'status' => 'Status',
            'is-active' => 'Cart Rule is Active',
            'channels' => 'Channels',
            'customer-groups' => 'Customer Groups',
            'coupon-type' => 'Coupon Type',
            'no-coupon' => 'No Coupon',
            'specific-coupon' => 'Specific Coupon',
            'auto-generate-coupon' => 'Auto Generate Coupon',
            'no' => 'No',
            'yes' => 'Yes',
            'coupon-code' => 'Coupon Code',
            'uses-per-coupon' => 'Uses Per Coupon',
            'uses-per-customer' => 'Uses Per Customer',
            'uses-per-customer-control-info' => 'Will be used for logged in customers only.',
            'from' => 'From',
            'to' => 'To',
            'priority' => 'Priority',
            'conditions' => 'Conditions',
            'condition-type' => 'Condition Type',
            'all-conditions-true' => 'All Conditions are True',
            'any-condition-true' => 'Any Condition is True',
            'add-condition' => 'Add Condition',
            'choose-condition-to-add' => 'Choose a condition to add',
            'cart-attribute' => 'Cart Attribute',
            'subtotal' => 'Subtotal',
            'total-items-qty' => 'Total Items Qty',
            'total-weight' => 'Total Weight',
            'payment-method' => 'Payment Method',
            'shipping-method' => 'Shipping Method',
            'shipping-postcode' => 'Shipping Zip/Postcode',
            'shipping-state' => 'Shipping State',
            'shipping-country' => 'Shipping Country',
            'cart-item-attribute' => 'Cart Item Attribute',
            'price-in-cart' => 'Price in Cart',
            'qty-in-cart' => 'Qty in Cart',
            'product-attribute' => 'Product Attribute',
            'attribute-name-children-only' => ':attribute_name (Children Only)',
            'attribute-name-parent-only' => ':attribute_name (Parent Only)',
            'is-equal-to' => 'Is equal to',
            'is-not-equal-to' => 'Is not equal to',
            'equals-or-greater-than' => 'Equals or greater than',
            'equals-or-less-than' => 'Equals or less than',
            'greater-than' => 'Greater than',
            'less-than' => 'Less than',
            'contain' => 'Contain',
            'contains' => 'Contains',
            'does-not-contain' => 'Does not contain',
            'actions' => 'Actions',
            'action-type' => 'Action Type',
            'percentage-product-price' => 'Percentage of Product Price',
            'fixed-amount' => 'Fixed Amount',
            'fixed-amount-whole-cart' => 'Fixed Amount to Whole Cart',
            'buy-x-get-y-free' => 'Buy X Get Y Free',
            'discount-amount' => 'Discount Amount',
            'discount-quantity' => 'Maximum Quantity Allowed to be Discounted',
            'discount-step' => 'Buy X Quantity',
            'free-shipping' => 'Free Shipping',
            'apply-to-shipping' => 'Apply to Shipping',
            'coupon-codes' => 'Coupon Codes',
            'coupon-qty' => 'Coupon Qty',
            'code-length' => 'Code Length',
            'code-format' => 'Code Format',
            'alphanumeric' => 'Alphanumeric',
            'alphabetical' => 'Alphabetical',
            'numeric' => 'Numeric',
            'code-prefix' => 'Code Prefix',
            'code-suffix' => 'Code Suffix',
            'generate' => 'Generate',
            'cart-rule-not-defind-error' => 'Cart rule is not defined',
            'mass-delete-success' => 'All the selected coupons have been deleted successfully.',
            'end-other-rules' => 'End Other Rules',
            'children-categories' => 'Categories (Children Only)',
            'parent-categories' => 'Categories (Parent Only)',
            'categories' => 'Categories',
            'attribute_family' => 'Attribute Family'
        ],

        'catalog-rules' => [
            'title' => 'Catalog Rules',
            'add-title' => 'Add Catalog Rule',
            'edit-title' => 'Edit Catalog Rule',
            'save-btn-title' => 'Save Catalog Rule',
            'rule-information' => 'Rule Information',
            'name' => 'Name',
            'description' => 'Description',
            'status' => 'Status',
            'is-active' => 'Catalog Rule is Active',
            'channels' => 'Channels',
            'customer-groups' => 'Customer Groups',
            'no' => 'No',
            'yes' => 'Yes',
            'from' => 'From',
            'to' => 'To',
            'priority' => 'Priority',
            'conditions' => 'Conditions',
            'condition-type' => 'Condition Type',
            'all-conditions-true' => 'All Conditions are True',
            'any-condition-true' => 'Any Condition is True',
            'add-condition' => 'Add Condition',
            'choose-condition-to-add' => 'Choose a condition to add',
            'product-attribute' => 'Product Attribute',
            'attribute-name-children-only' => ':attribute_name (Children Only)',
            'attribute-name-parent-only' => ':attribute_name (Parent Only)',
            'is-equal-to' => 'Is equal to',
            'is-not-equal-to' => 'Is not equal to',
            'equals-or-greater-than' => 'Equals or greater than',
            'equals-or-less-than' => 'Equals or less than',
            'greater-than' => 'Greater than',
            'less-than' => 'Less than',
            'contain' => 'Contain',
            'contains' => 'Contains',
            'does-not-contain' => 'Does not contain',
            'actions' => 'Actions',
            'action-type' => 'Action Type',
            'percentage-product-price' => 'Percentage of Product Price',
            'fixed-amount' => 'Fixed Amount',
            'fixed-amount-whole-cart' => 'Fixed Amount to Whole Catalog',
            'buy-x-get-y-free' => 'Buy X Get Y Free',
            'discount-amount' => 'Discount Amount',
            'mass-delete-success' => 'All the selected index of coupons have been deleted successfully.',
            'end-other-rules' => 'End Other Rules',
            'categories' => 'Categories',
            'attribute_family' => 'Attribute Family'
        ]
    ],

    'error' => [
        'go-to-home' => 'GO TO HOME',
        'in-maitainace' => 'In Maintenance',
        'right-back' => 'Be Right Back',

        '404' => [
            'page-title' => '404 Page not found',
            'name' => '404',
            'title' => 'Page Not found',
            'message' => 'The Page you are looking for does not exist or have been moved. Navigate using sidemenu.'
        ],
        '403' => [
            'page-title' => '403 forbidden Error',
            'name' => '403',
            'title' => 'Forbidden error',
            'message' => 'You do not have permission to access this page'
        ],
        '500' => [
            'page-title' => '500 Internal Server Error',
            'name' => '500',
            'title' => 'Internal Server Error',
            'message' => 'The Server Encountered an internal error.'
        ],
        '401' => [
            'page-title' => '401 Unauthorized Error',
            'name' => '401',
            'title' => 'Unauthorized Error',
            'message' => 'The request has not been applied because it lacks valid authentication credentials for the target resource.'
        ],
    ],

    'export' => [
        'export' => 'Export',
        'import' => 'Import',
        'format' => 'Select Format',
        'download' => 'Download',
        'upload' => 'Upload',
        'csv' => 'CSV',
        'xls' => 'XLS',
        'file' => 'File',
        'upload-error' => 'The file must be a file of type: xls, xlsx, csv.',
        'duplicate-error' => 'Identifier must be unique, duplicate identifier :identifier at row :position.',
        'enough-row-error' => 'file has not enough rows',
        'allowed-type' => 'Allowed Type :',
        'file-type' => 'csv, xls, xlsx.',
        'no-records' => 'Nothing to export',
        'illegal-format' => 'Error! This type of format is either not supported or its illegal format'
    ],

    'cms' => [
        'pages' => [
            'general' => 'General',
            'seo' => 'SEO',
            'pages' => 'Pages',
            'title' => 'Pages',
            'add-title' => 'Add Page',
            'content' => 'Content',
            'url-key' => 'URL Key',
            'channel' => 'Channels',
            'locale' => 'Locales',
            'create-btn-title' => 'Save Page',
            'edit-title' => 'Edit Page',
            'edit-btn-title' => 'Save Page',
            'create-success' => 'Page created successfully',
            'create-partial' => 'Some of the pages requested already exists',
            'create-failure' => 'All pages requested already exists',
            'update-success' => 'Page updated successfully',
            'update-failure' => 'Page cannot be updated',
            'page-title' => 'Page Title',
            'layout' => 'Layout',
            'meta_keywords' => 'Meta Keywords',
            'meta_description' => 'Meta Description',
            'meta_title' => 'Meta Title',
            'delete-success' => 'CMS page deleted successfully',
            'delete-failure' => 'CMS page cannot be deleted',
            'preview' => 'Preview',
            'one-col' => '<div class="mt-10">Use class: <b>"static-container one-column"</b> for one column layout.</div>',
            'two-col' => '<div class="mt-10">Use class: <b>"static-container two-column"</b> for two column layout.</div>',
            'three-col' => '<div class="mt-10">Use class: <b>"static-container three-column"</b> for three column layout.</div>',
            'helper-classes' => 'Helper Classes'
        ]
    ],

    'response' => [
        'being-used' => 'This resource :name is getting used in :source',
        'cannot-delete-default' => 'Cannot delete the default channel',
        'create-success' => ':name created successfully.',
        'update-success' => ':name updated successfully.',
        'delete-success' => ':name deleted successfully.',
        'delete-failed' => 'Error encountered while deleting :name.',
        'last-delete-error' => 'At least one :name is required.',
        'user-define-error' => 'Can not delete system :name',
        'attribute-error' => ':name is used in configurable products.',
        'attribute-product-error' => ':name is used in products.',
        'customer-associate' => ':name can not be deleted because customer is associated with this group.',
        'currency-delete-error' => 'This currency is set as channel base currency so it can not be deleted.',
        'upload-success' => ':name uploaded successfully.',
        'delete-category-root' => 'Cannot delete the root category',
        'create-root-failure' => 'Category with name root already exists',
        'cancel-success' => ':name canceled successfully.',
        'cancel-error' => ':name can not be canceled.',
        'already-taken' => 'The :name has already been taken.',
        'order-pending' => 'Cannot delete account because some Order(s) are pending or processing state.'
    ],

    'footer' => [
        'copy-right' => 'Powered by <a href="https://bagisto.com/" target="_blank">Bagisto</a>, A Community Project by <a href="https://webkul.com/" target="_blank">Webkul</a>',
    ],

    'admin' => [
        'emails' => [
            'email' => 'Email',
            'notification_label' => 'Notifications',
            'notifications' => [
                'verification' => 'Send verification E-mail',
                'registration' => 'Send registration E-mail',
                'customer' => 'Send customer E-mail',
                'new-order' => 'Send Order Confirmation E-mail',
                'new-admin' => 'Send Admin Invitation E-mail',
                'new-invoice' => 'Send Invoice Confirmation E-mail',
                'new-refund' => 'Send Refund Notification E-mail',
                'new-shipment' => 'Send Shipment Notification E-mail',
                'new-inventory-source' => 'Send Inventory Source Notification E-mail',
                'cancel-order' => 'Send cancel Order Notification E-mail',
            ],

        ],
        'system' => [
            'catalog' => 'Catalog',
            'products' => 'Products',
            'guest-checkout' => 'Guest Checkout',
            'allow-guest-checkout' => 'Allow Guest Checkout',
            'allow-guest-checkout-hint' => 'Hint: If turned on, this option can be configured for each product specifically.',
            'review' => 'Review',
            'allow-guest-review' => 'Allow Guest Review',
            'inventory' => 'Inventory',
            'stock-options' => 'Stock Options',
            'allow-backorders' => 'Allow Backorders',
            'customer' => 'Customer',
            'settings' => 'Settings',
            'address' => 'Address',
            'street-lines' => 'Lines in a Street Address',
            'sales' => 'Sales',
            'shipping-methods' => 'Shipping Methods',
            'free-shipping' => 'Free Shipping',
            'flate-rate-shipping' => 'Flat Rate Shipping',
            'shipping' => 'Shipping',
            'origin' => 'Origin',
            'country' => 'Country',
            'state' => 'State',
            'zip' => 'Zip',
            'city' => 'City',
            'street-address' => 'Street Address',
            'title' => 'Title',
            'description' => 'Description',
            'rate' => 'Rate',
            'status' => 'Status',
            'type' => 'Type',
            'payment-methods' => 'Payment Methods',
            'cash-on-delivery' => 'Cash On Delivery',
            'money-transfer' => 'Money Transfer',
            'paypal-standard' => 'Paypal Standard',
            'business-account' => 'Business Account',
            'newsletter' => 'NewsLetter Subscription',
            'newsletter-subscription' => 'Allow NewsLetter Subscription',
            'email' => 'Email Verification',
            'email-verification' => 'Allow Email Verification',
            'sort_order' => 'Sort Order',
            'general' => 'General',
            'footer' => 'Footer',
            'content' => 'Content',
            'footer-content' => 'Footer Text',
            'footer-toggle' => 'Toggle footer',
            'locale-options' => 'Unit Options',
            'weight-unit' => 'Weight Unit',
            'email-settings'    => 'Email Settings',
            'email-sender-name' => 'Email Sender Name',
            'shop-email-from'   => 'Shop Email Address [For sending emails]',
            'admin-name'    => 'Admin Name',
            'admin-email' => 'Admin Email',
            'admin-page-limit' => 'Default Items Per Page (Admin)',
            'design' => 'Design',
            'admin-logo' => 'Admin Logo',
            'logo-image' => 'Logo Image',
            'credit-max' => 'Customer Credit Max',
            'credit-max-value' => 'Credit Max Value',
            'use-credit-max' => 'Use Credit Max',
            'order-settings' => 'Order Settings',
            'orderNumber' => 'Order Number Settings',
            'order-number-prefix' => 'Order Number Prefix',
            'order-number-length' => 'Order Number Length',
            'order-number-suffix' => 'Order Number Suffix',
            'default' => 'Default',
            'sandbox' => 'Sandbox',
            'all-channels' => 'All',
            'all-locales' => 'All',
            'invoice-slip-design' => 'Invoice Slip Design',
            'logo' => 'logo'
       ]
    ]
];
